const jwt = require("jsonwebtoken");

module.exports = (roles = []) => (req, res, next) => {
    const token = req.headers.authorization?.split(" ")[1];

    if (!token) {
        return res.status(401).json({ message: "No Token" });
    }

    const decode = jwt.verify(token, process.env.JWT_SECRET);

    if (roles.length && !roles.includes(decode.role)) {
        return res.status(403).json({ message: "Access Denied" });
    }

    req.user = decode;
    next();
};